﻿using UnrealBuildTool;

public class RuntimeAudioImporterSileroVADEditor : ModuleRules
{
    public RuntimeAudioImporterSileroVADEditor(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;

        PublicDependencyModuleNames.AddRange(
            new string[]
            {
                "Core",
            }
        );

        PrivateDependencyModuleNames.AddRange(
            new string[]
            {
                "CoreUObject",
                "Engine",
                "Slate",
                "SlateCore",
                "UnrealEd",
                "RuntimeAudioImporterSileroVAD"
            }
        );
        
        PrivateDependencyModuleNames.AddRange(
            new string[]
            {
                "Projects",
                "GameProjectGeneration",
                "DesktopPlatform"
            }
        );
		
        if (Target.Version.MajorVersion >= 5 && Target.Version.MinorVersion >= 0)
        {
            PrivateDependencyModuleNames.AddRange(
                new string[]
                {
                    "DeveloperToolSettings"
                }
            );
        }
    }
}