﻿#include "RuntimeAudioImporterSileroVADEditor.h"

#include "RuntimeAudioImporterSileroVAD.h"
#include "Settings/ProjectPackagingSettings.h"
#include "Misc/EngineVersionComparison.h"

DEFINE_LOG_CATEGORY(LogRuntimeAudioImporterSileroVADEditor);

#define LOCTEXT_NAMESPACE "FRuntimeAudioImporterSileroVADEditorModule"

void FRuntimeAudioImporterSileroVADEditorModule::StartupModule()
{
	UpdatePackagingSettings();
}

void FRuntimeAudioImporterSileroVADEditorModule::ShutdownModule()
{
    
}

bool FRuntimeAudioImporterSileroVADEditorModule::UpdatePackagingSettings() const
{
	const FRuntimeAudioImporterSileroVADModule* RuntimeTextToSpeechModulePtr = static_cast<FRuntimeAudioImporterSileroVADModule*>(FModuleManager::Get().GetModule("RuntimeAudioImporterSileroVAD"));
	if (!RuntimeTextToSpeechModulePtr)
	{
		UE_LOG(LogRuntimeAudioImporterSileroVADEditor, Error, TEXT("Cannot get the RuntimeTextToSpeech module"));
		return false;
	}

	UProjectPackagingSettings* PackagingSettings = GetMutableDefault<UProjectPackagingSettings>();
	if (!PackagingSettings)
	{
		UE_LOG(LogRuntimeAudioImporterSileroVADEditor, Error, TEXT("Cannot get the packaging settings"));
		return false;
	}

	auto AddPathIfNotPresent = [&PackagingSettings](const FString& NewPath)
	{
		const bool bIsAlreadyInPath = PackagingSettings->DirectoriesToAlwaysCook.ContainsByPredicate([&NewPath](const FDirectoryPath& DirPath)
		{
			return FPaths::IsSamePath(DirPath.Path, NewPath);
		});

		if (!bIsAlreadyInPath)
		{
			FDirectoryPath DirPath;
			DirPath.Path = NewPath;
			PackagingSettings->DirectoriesToAlwaysCook.Add(DirPath);
		}
	};

	AddPathIfNotPresent(RuntimeTextToSpeechModulePtr->GetVADModelDataPackagePath());

#if UE_VERSION_OLDER_THAN(5, 0, 0)
	PackagingSettings->UpdateDefaultConfigFile();
#else
	PackagingSettings->TryUpdateDefaultConfigFile();
#endif

	return true;
}

#undef LOCTEXT_NAMESPACE
    
IMPLEMENT_MODULE(FRuntimeAudioImporterSileroVADEditorModule, RuntimeAudioImporterSileroVADEditor)
